; ====================================================================================================
;
; enemy4.asm
;
; included from enemy.asm
;
; ====================================================================================================
SECTION code_user

CHRNO_ENEMY4:           EQU 8       ; キャラクター番号

; ====================================================================================================
; テキ4初期化
; パラメタなし
; ====================================================================================================
INIT_ENEMY4:
    CALL INIT_ENEMY1                ; まずはテキ１と同じ初期化を行う

    ; ■テキ１の設定からオーバーライドする
    LD (IX),CHRNO_ENEMY4            ; キャラクター番号
    LD (IX+5),43                    ; スプライトパターンNo
    LD (IX+6),14                    ; カラーコード
    LD (IX+8),$FF                   ; 移動量

    LD HL,(ENEMY_PARAM_ADDR)        ; HL <- パラメータのアドレス
    INC HL                          ; Y座標読み飛ばし
    INC HL                          ; X座標読み飛ばし
    LD A,(HL)                       ; 方向
    CP $FF
    JR NZ,INIT_ENEMY4_L1            ; $FF以外ならランダム設定しない
    CALL GET_RND                    ; 乱数取得(0〜255)
    AND @00000111                   ; 取得した乱数から0〜7の値を取得する
    ADD A,2
    AND @00001110                   ; 下位1ビットを0にする(=2,4,6,8の値にする)
    DEC A                           ; A=A-1(=1,3,5,7の値にする)
INIT_ENEMY4_L1:
    LD (IX+7),A                     ; 移動方向(1=上、3=右、5=下、7=左)

    LD BC,ANIM_PTN_ENEMY4
    LD (IX+9),C                     ; アニメーションテーブルアドレス
    LD (IX+10),B

    ; ■テキ4の独自のプロパティ
    LD (IX+13),0                    ; 方向変更するまでのカウンタ
    LD (IX+14),0                    ; 追尾する方向(0=上下、1=左右)

    RET


; ====================================================================================================
; テキ4処理サブルーチン
; ====================================================================================================
UPDATE_ENEMY4:

    CALL UPDATE_ENEMY1              ; 処理自体はテキ1と同じ
    RET


; ====================================================================================================
; 定数エリア
; romに格納される
; ====================================================================================================
SECTION rodata_user

; ■アニメーションパターン
ANIM_PTN_ENEMY4:
	DB 43,43,43,43,43,43,43,43,44,44,44,44,45,45,45,45,45,45,45,45,44,44,44,44,$FF
